/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.project;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.desktop.project.ProjectControllerUIImpl;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceMetaData;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class WorkspacePropertiesEditor
extends JPanel {
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private JPanel innerPanel;
    private JLabel labelDescription;
    private JLabel labelName;
    private JLabel labelTitle;
    private JTextField nameTextField;
    private JTextField titleTextField;

    public WorkspacePropertiesEditor() {
        this.initComponents();
    }

    public static ValidationPanel createValidationPanel(WorkspacePropertiesEditor innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        innerPanel.nameTextField.setName(innerPanel.labelName.getText().replace(":", ""));
        group.add((Object)innerPanel.nameTextField, (Validator)StringValidators.REQUIRE_NON_EMPTY_STRING);
        return validationPanel;
    }

    public void setup(Workspace workspace) {
        WorkspaceMetaData info = workspace.getWorkspaceMetadata();
        this.descriptionTextArea.setText(info.getDescription());
        this.titleTextField.setText(info.getTitle());
        this.nameTextField.setText(workspace.getName());
    }

    public void unsetup(Workspace workspace) {
        WorkspaceMetaData info = workspace.getWorkspaceMetadata();
        if (!this.descriptionTextArea.getText().isEmpty() && !this.descriptionTextArea.getText().equals(info.getDescription())) {
            info.setDescription(this.descriptionTextArea.getText());
        }
        if (!this.nameTextField.getText().isEmpty() && !this.nameTextField.getText().equals(workspace.getName())) {
            ((ProjectControllerUIImpl)Lookup.getDefault().lookup(ProjectControllerUIImpl.class)).renameWorkspace(this.nameTextField.getText());
        }
        if (!this.titleTextField.getText().isEmpty() && !this.titleTextField.getText().equals(info.getTitle())) {
            info.setTitle(this.titleTextField.getText());
        }
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.nameTextField = new JTextField();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.labelName = new JLabel();
        this.labelDescription = new JLabel();
        this.labelTitle = new JLabel();
        this.titleTextField = new JTextField();
        this.innerPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WorkspacePropertiesEditor.class, (String)"WorkspacePropertiesEditor.innerPanel.border.title")));
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setRows(3);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.labelName.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.labelName, (String)NbBundle.getMessage(WorkspacePropertiesEditor.class, (String)"WorkspacePropertiesEditor.labelName.text"));
        this.labelDescription.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.labelDescription, (String)NbBundle.getMessage(WorkspacePropertiesEditor.class, (String)"WorkspacePropertiesEditor.labelDescription.text"));
        this.labelTitle.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.labelTitle, (String)NbBundle.getMessage(WorkspacePropertiesEditor.class, (String)"WorkspacePropertiesEditor.labelTitle.text"));
        GroupLayout innerPanelLayout = new GroupLayout(this.innerPanel);
        this.innerPanel.setLayout(innerPanelLayout);
        innerPanelLayout.setHorizontalGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerPanelLayout.createSequentialGroup().addContainerGap().addGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerPanelLayout.createSequentialGroup().addComponent(this.labelName, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField)).addGroup(innerPanelLayout.createSequentialGroup().addGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.labelDescription, -1, 82, Short.MAX_VALUE).addComponent(this.labelTitle, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleTextField).addComponent(this.descriptionScrollPane, -1, 235, Short.MAX_VALUE)))).addContainerGap()));
        innerPanelLayout.setVerticalGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerPanelLayout.createSequentialGroup().addContainerGap().addGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.labelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTitle).addComponent(this.titleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(innerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerPanelLayout.createSequentialGroup().addComponent(this.labelDescription).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.descriptionScrollPane, -1, 150, Short.MAX_VALUE)).addGap(17, 17, 17)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.innerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.innerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

