/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.layout;

import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.UIManager;
import org.gephi.desktop.layout.LayoutPanel;
import org.gephi.layout.api.LayoutModel;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="LayoutTopComponent", iconBase="org/gephi/desktop/layout/resources/small.png", persistenceType=0)
public final class LayoutTopComponent
extends TopComponent {
    private final LayoutPanel layoutPanel;
    private LayoutModel model;

    public LayoutTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(LayoutTopComponent.class, (String)"CTL_LayoutTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.layoutPanel = new LayoutPanel();
        if (UIUtils.isAquaLookAndFeel()) {
            this.layoutPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.add(this.layoutPanel, "Center");
        ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                LayoutTopComponent.this.model = (LayoutModel)workspace.getLookup().lookup(LayoutModel.class);
                LayoutTopComponent.this.refreshModel();
            }

            public void unselect(Workspace workspace) {
                if (LayoutTopComponent.this.model != null) {
                    LayoutTopComponent.this.model.removePropertyChangeListener((PropertyChangeListener)LayoutTopComponent.this.layoutPanel);
                }
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                LayoutTopComponent.this.model = null;
                LayoutTopComponent.this.refreshModel();
            }
        });
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (projectController.getCurrentWorkspace() != null) {
            this.model = (LayoutModel)projectController.getCurrentWorkspace().getLookup().lookup(LayoutModel.class);
        }
        this.refreshModel();
    }

    private void refreshModel() {
        this.layoutPanel.refreshModel(this.model);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

