/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.math.RoundingMode;
import java.text.DecimalFormat;

public class StartEndTick {
    private final DecimalFormat decimalFormat = new DecimalFormat();
    private final int exponentMin;
    private final int exponentMax;
    private final double min;
    private final double max;

    public StartEndTick(double min, double max, int exponentMin, int exponentMax) {
        this.decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
        this.min = min;
        this.max = max;
        this.exponentMin = exponentMin;
        this.exponentMax = exponentMax;
    }

    public static StartEndTick create(double min, double max) {
        int exponentMin = (int)Math.round(Math.log10(min));
        int exponentMax = (int)Math.round(Math.log10(max));
        return new StartEndTick(min, max, exponentMin, exponentMax);
    }

    public int getExponentMax() {
        return this.exponentMax;
    }

    public int getExponentMin() {
        return this.exponentMin;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public String getStartValue() {
        if (this.exponentMin > 0) {
            return String.valueOf((long)this.min);
        }
        this.decimalFormat.setMaximumFractionDigits(Math.abs(this.exponentMin) + 2);
        return this.decimalFormat.format(this.min);
    }

    public String getEndValue() {
        if (this.exponentMax > 0) {
            return String.valueOf((long)this.max);
        }
        this.decimalFormat.setMaximumFractionDigits(Math.abs(this.exponentMax) + 2);
        return this.decimalFormat.format(this.max);
    }
}

