/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.io.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.gephi.desktop.io.export.DesktopExportController;
import org.gephi.desktop.io.export.GraphFileExporterUIPanel;
import org.gephi.desktop.io.export.TopDialog;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.io.exporter.spi.FileExporterBuilder;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.io.exporter.spi.GraphFileExporterBuilder;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.ui.utils.DialogFileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AbstractExporterUI<T extends FileExporterBuilder> {
    private FileExporterBuilder selectedBuilder;
    private Exporter selectedExporter;
    private File selectedFile;
    private boolean visibleOnlyGraph = false;
    private boolean exportAll = false;
    private JDialog dialog;
    private final Class<T> builderClass;
    private final String preferencesPrefix;

    public AbstractExporterUI(String preferencesPrefix, Class<T> builderClass) {
        this.builderClass = builderClass;
        this.preferencesPrefix = preferencesPrefix;
    }

    public void action() {
        this.action(Lookup.getDefault().lookupAll(this.builderClass));
    }

    public void action(final Collection<? extends T> exporterBuilders) {
        String LAST_PATH = this.preferencesPrefix + "_Last_Path";
        String LAST_PATH_DEFAULT = this.preferencesPrefix + "_Last_Path_Default";
        final String LAST_FILE_FILTER = this.preferencesPrefix + "_Last_File_Filter";
        final DesktopExportController exportController = (DesktopExportController)Lookup.getDefault().lookup(DesktopExportController.class);
        if (exportController == null) {
            return;
        }
        String lastPathDefault = NbPreferences.forModule(AbstractExporterUI.class).get(LAST_PATH_DEFAULT, null);
        String lastPath = NbPreferences.forModule(AbstractExporterUI.class).get(LAST_PATH, lastPathDefault);
        String lastFileFilterString = NbPreferences.forModule(AbstractExporterUI.class).get(LAST_FILE_FILTER, null);
        File lastPathDir = null;
        if (lastPath != null) {
            for (lastPathDir = new File(lastPath); lastPathDir != null && (lastPathDir.isFile() || !lastPathDir.exists()); lastPathDir = lastPathDir.getParentFile()) {
            }
        }
        final JButton optionsButton = new JButton(NbBundle.getMessage(AbstractExporterUI.class, (String)"AbstractExporterUI.optionsButton.name"));
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExporterUI exporterUI = exportController.getExportController().getUI(AbstractExporterUI.this.selectedExporter);
                if (exporterUI != null) {
                    JPanel panel = exporterUI.getPanel();
                    exporterUI.setup(AbstractExporterUI.this.selectedExporter);
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(AbstractExporterUI.class, (String)"AbstractExporterUI.optionsDialog.title", (Object)AbstractExporterUI.this.selectedBuilder.getName()));
                    TopDialog topDialog = new TopDialog(AbstractExporterUI.this.dialog, dd.getTitle(), dd.isModal(), (NotifyDescriptor)dd, dd.getClosingOptions(), dd.getButtonListener());
                    topDialog.setVisible(true);
                    Object result = dd.getValue() != null ? dd.getValue() : NotifyDescriptor.CLOSED_OPTION;
                    exporterUI.unsetup(result == NotifyDescriptor.OK_OPTION);
                }
            }
        });
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)optionsButton, "East");
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        final JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)optionsPanel, "North");
        GraphFileExporterUIPanel graphSettings = new GraphFileExporterUIPanel();
        graphSettings.setVisibleOnlyGraph(this.visibleOnlyGraph);
        if (GraphFileExporterBuilder.class.isAssignableFrom(this.builderClass)) {
            southPanel.add((Component)graphSettings, "Center");
        }
        final JFileChooser chooser = new JFileChooser(lastPathDir){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                AbstractExporterUI.this.dialog = super.createDialog(parent);
                AbstractExporterUI.this.dialog.setSize(640, 480);
                AbstractExporterUI.this.dialog.setResizable(true);
                Component c = AbstractExporterUI.this.dialog.getContentPane().getComponent(0);
                if (c != null && c instanceof JComponent) {
                    Insets insets = ((JComponent)c).getInsets();
                    southPanel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
                }
                AbstractExporterUI.this.dialog.getContentPane().add((Component)southPanel, "South");
                return AbstractExporterUI.this.dialog;
            }

            @Override
            public void approveSelection() {
                if (AbstractExporterUI.this.canExport(this)) {
                    super.approveSelection();
                }
            }
        };
        chooser.setFileSelectionMode(this.exportAll ? 1 : 0);
        chooser.setDialogTitle(NbBundle.getMessage(AbstractExporterUI.class, (String)"AbstractExporterUI.filechooser.title"));
        chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DialogFileFilter fileFilter = (DialogFileFilter)evt.getNewValue();
                NbPreferences.forModule(AbstractExporterUI.class).put(LAST_FILE_FILTER, fileFilter.getExtensions().toString());
                AbstractExporterUI.this.selectedBuilder = AbstractExporterUI.this.getExporter(exporterBuilders, fileFilter);
                if (AbstractExporterUI.this.selectedBuilder != null) {
                    AbstractExporterUI.this.selectedExporter = AbstractExporterUI.this.selectedBuilder.buildExporter();
                    Workspace workspace = ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace();
                    AbstractExporterUI.this.selectedExporter.setWorkspace(workspace);
                    ExporterUI ui = exportController.getExportController().getUI(AbstractExporterUI.this.selectedExporter);
                    if (ui != null) {
                        ui.setup(AbstractExporterUI.this.selectedExporter);
                        optionsButton.setEnabled(true);
                    } else {
                        optionsButton.setEnabled(false);
                    }
                } else {
                    optionsButton.setEnabled(false);
                }
                if (AbstractExporterUI.this.selectedFile != null && !AbstractExporterUI.this.exportAll) {
                    String fileName = AbstractExporterUI.this.selectedFile.getName();
                    String directoryPath = chooser.getCurrentDirectory().getAbsolutePath();
                    if (fileName.lastIndexOf(".") != -1) {
                        fileName = fileName.substring(0, fileName.lastIndexOf("."));
                        fileName = fileName.concat((String)fileFilter.getExtensions().get(0));
                        AbstractExporterUI.this.selectedFile = new File(directoryPath, fileName);
                        chooser.setSelectedFile(AbstractExporterUI.this.selectedFile);
                    }
                }
            }
        });
        chooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    AbstractExporterUI.this.selectedFile = (File)evt.getNewValue();
                }
            }
        });
        final JCheckBox exportAllCheckBox = new JCheckBox(NbBundle.getMessage(AbstractExporterUI.class, (String)"AbstractExporterUI.exportAllCheckBox.text"));
        exportAllCheckBox.setSelected(this.exportAll);
        exportAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractExporterUI.this.exportAll = exportAllCheckBox.isSelected();
                chooser.setFileSelectionMode(AbstractExporterUI.this.exportAll ? 1 : 0);
            }
        });
        optionsPanel.add((Component)exportAllCheckBox, "West");
        DialogFileFilter defaultFileFilter = null;
        DialogFileFilter lastFileFilter = null;
        for (FileExporterBuilder graphFileExporter : exporterBuilders) {
            for (FileType fileType : graphFileExporter.getFileTypes()) {
                DialogFileFilter dialogFileFilter = new DialogFileFilter(fileType.getName());
                dialogFileFilter.addExtensions(fileType.getExtensions());
                if (defaultFileFilter == null) {
                    defaultFileFilter = dialogFileFilter;
                }
                if (lastFileFilterString != null && dialogFileFilter.getExtensions().toString().equals(lastFileFilterString)) {
                    lastFileFilter = dialogFileFilter;
                }
                chooser.addChoosableFileFilter((FileFilter)dialogFileFilter);
            }
        }
        chooser.setAcceptAllFileFilterUsed(false);
        if (lastFileFilter != null) {
            defaultFileFilter = lastFileFilter;
        }
        chooser.setFileFilter((FileFilter)defaultFileFilter);
        this.selectedFile = this.exportAll ? chooser.getCurrentDirectory() : (lastPathDir != null && lastPathDir.exists() && lastPathDir.isDirectory() ? new File(lastPath) : new File(chooser.getCurrentDirectory(), NbBundle.getMessage(AbstractExporterUI.class, (String)"AbstractExporterUI.untitledFileName") + (String)defaultFileFilter.getExtensions().get(0)));
        chooser.setSelectedFile(this.selectedFile);
        int returnFile = chooser.showSaveDialog(null);
        if (returnFile == 0) {
            File file = chooser.getSelectedFile();
            file = FileUtil.normalizeFile((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            NbPreferences.forModule(AbstractExporterUI.class).put(LAST_PATH, file.getAbsolutePath());
            this.visibleOnlyGraph = graphSettings.isVisibleOnlyGraph();
            if (this.selectedExporter instanceof GraphExporter) {
                ((GraphExporter)this.selectedExporter).setExportVisible(this.visibleOnlyGraph);
            }
            if (this.exportAll) {
                String extension = this.selectedBuilder.getFileTypes()[0].getExtension();
                exportController.exportFiles(fileObject, this.selectedExporter, extension);
            } else {
                exportController.exportFile(fileObject, this.selectedExporter);
            }
        }
        this.dialog = null;
    }

    private boolean canExport(JFileChooser chooser) {
        if (this.exportAll) {
            return true;
        }
        File file = chooser.getSelectedFile();
        String defaultExtension = this.selectedBuilder.getFileTypes()[0].getExtension();
        try {
            if (!file.getPath().endsWith(defaultExtension)) {
                this.selectedFile = file = new File(file.getPath() + defaultExtension);
                chooser.setSelectedFile(file);
            }
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    String failMsg = NbBundle.getMessage(AbstractExporterUI.class, (String)"AbstractExporterUI.SaveFailed", (Object[])new Object[]{file.getPath()});
                    JOptionPane.showMessageDialog(chooser, failMsg);
                    return false;
                }
            } else {
                String overwriteMsg = NbBundle.getMessage(AbstractExporterUI.class, (String)"AbstractExporterUI.overwriteDialog.message", (Object[])new Object[]{file.getPath()});
                if (JOptionPane.showConfirmDialog(chooser, overwriteMsg, NbBundle.getMessage(AbstractExporterUI.class, (String)"AbstractExporterUI.overwriteDialog.title"), 0) != 0) {
                    return false;
                }
            }
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage(), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
            return false;
        }
        return true;
    }

    private FileExporterBuilder getExporter(Collection<? extends T> exporterBuilders, DialogFileFilter fileFilter) {
        for (FileExporterBuilder graphFileExporter : exporterBuilders) {
            for (FileType fileType : graphFileExporter.getFileTypes()) {
                DialogFileFilter tempFilter = new DialogFileFilter(fileType.getName());
                tempFilter.addExtensions(fileType.getExtensions());
                if (!tempFilter.equals((Object)fileFilter)) continue;
                return graphFileExporter;
            }
        }
        return null;
    }
}

