/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class FileFilterSupport {
    private static final Logger LOG = Logger.getLogger(FileFilterSupport.class.getName());

    private FileFilterSupport() {
    }

    private static String constructFilterDisplayName(String displayName, List<FilterElement> elements) {
        StringBuilder sb = new StringBuilder(displayName);
        boolean first = true;
        sb.append(" [");
        for (FilterElement el : elements) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(el.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    private static boolean accept(File file, List<FilterElement> elements) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            for (FilterElement elm : elements) {
                if (!elm.accept(file)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<FileFilter> findRegisteredFileFilters() {
        LinkedList<FileFilter> filters = new LinkedList<FileFilter>();
        FileObject root = FileUtil.getConfigFile((String)"Services/MIMEResolver");
        HashMap<String, HashSet<FileObject>> filterNameToResolversMap = new HashMap<String, HashSet<FileObject>>();
        for (FileObject child : root.getChildren()) {
            String f;
            if (child.isFolder()) continue;
            int i = 0;
            while ((f = (String)child.getAttribute("fileChooser." + i)) != null) {
                HashSet<FileObject> set = (HashSet<FileObject>)filterNameToResolversMap.get(f);
                if (set == null) {
                    set = new HashSet<FileObject>();
                    filterNameToResolversMap.put(f, set);
                }
                set.add(child);
                ++i;
            }
        }
        for (Map.Entry entry : filterNameToResolversMap.entrySet()) {
            filters.add(FileFilterSupport.createFilter((String)entry.getKey(), (Set)entry.getValue()));
        }
        return FileFilterSupport.sortFiltersByDescription(filters);
    }

    private static FileFilter createFilter(String name, Set<FileObject> resolvers) {
        ArrayList<FilterElement> elems = new ArrayList<FilterElement>(3);
        for (FileObject fo : resolvers) {
            String lastAtt;
            int i = 0;
            while ((lastAtt = (String)fo.getAttribute("ext." + i)) != null) {
                FileFilterSupport.addExtensionToList(elems, lastAtt);
                ++i;
            }
            int n = 0;
            while ((lastAtt = (String)fo.getAttribute("fileName." + n++)) != null) {
                FileFilterSupport.addNameToList(elems, lastAtt);
            }
            String type = (String)fo.getAttribute("mimeType");
            if (type != null) {
                FileFilterSupport.addMimeTypeExts(elems, type);
            }
            int t = 0;
            while ((type = (String)fo.getAttribute("mimeType." + t++)) != null) {
                FileFilterSupport.addMimeTypeExts(elems, type);
            }
        }
        FileFilterSupport.sortFilterElements(elems);
        return new FileFilterImpl(name, elems);
    }

    private static void addMimeTypeExts(List<FilterElement> exts, String type) {
        FileFilterSupport.addAllExtensionsToList(exts, FileUtil.getMIMETypeExtensions((String)type));
    }

    private static void addAllExtensionsToList(List<FilterElement> list, List<String> toAdd) {
        for (String s : toAdd) {
            FileFilterSupport.addExtensionToList(list, s);
        }
    }

    private static void addExtensionToList(List<FilterElement> list, String ext) {
        FileFilterSupport.addFilterElementToList(list, FilterElement.createForExtension(ext));
    }

    private static void addNameToList(List<FilterElement> list, String name) {
        Pattern p = Pattern.compile("\\[([^,]+), (true|false), (true|false)\\](\\S*)");
        Matcher m = p.matcher(name);
        if (m.find()) {
            String fileName = m.group(1);
            boolean substring = m.group(2).equals("true");
            boolean ignoreCase = m.group(3).equals("true");
            String extension = m.group(4);
            FileFilterSupport.addFilterElementToList(list, FilterElement.createForFileName(fileName, extension, substring, ignoreCase));
        } else {
            LOG.log(Level.INFO, "Incorrect name pattern {0}", name);
        }
    }

    private static void addFilterElementToList(List<FilterElement> list, FilterElement newItem) {
        block5: for (int i = 0; i < list.size(); ++i) {
            FilterElement el = list.get(i);
            FilterElement.ComparisonResult result = newItem.compare(el);
            switch (result) {
                case DIFFERENT: {
                    continue block5;
                }
                case THE_SAME: 
                case WORSE: {
                    return;
                }
                case BETTER: {
                    list.set(i, newItem);
                    return;
                }
            }
        }
        list.add(newItem);
    }

    private static List<FileFilter> sortFiltersByDescription(List<FileFilter> list) {
        Collections.sort(list, new Comparator<FileFilter>(){

            @Override
            public int compare(FileFilter o1, FileFilter o2) {
                return o1.getDescription().compareTo(o2.getDescription());
            }
        });
        return list;
    }

    private static List<FilterElement> sortFilterElements(List<FilterElement> elements) {
        Collections.sort(elements, new Comparator<FilterElement>(){

            @Override
            public int compare(FilterElement o1, FilterElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return elements;
    }

    private static abstract class FilterElement {
        private FilterElement() {
        }

        public abstract String getName();

        public abstract boolean accept(File var1);

        public abstract ComparisonResult compare(FilterElement var1);

        public static FilterElement createForExtension(String ext) {
            return new ExtensionBasedFilterElement(ext);
        }

        public static FilterElement createForFileName(String name, String extension, boolean substring, boolean ignoreCase) {
            return new NameBasedFilterElement(name, extension, substring, ignoreCase);
        }

        private static class NameBasedFilterElement
        extends FilterElement {
            String name;
            String ext;
            boolean substring;
            boolean ignoreCase;
            Pattern p;

            public NameBasedFilterElement(String name, String ext, boolean substring, boolean ignoreCase) {
                this.name = name;
                this.ext = ext;
                this.substring = substring;
                this.ignoreCase = ignoreCase;
                StringBuilder sb = new StringBuilder();
                if (ignoreCase) {
                    sb.append("(?i)");
                }
                if (substring) {
                    sb.append(".*");
                }
                sb.append(name);
                if (substring) {
                    sb.append(".*");
                }
                if (!ext.isEmpty()) {
                    sb.append("\\.");
                    sb.append(ext);
                }
                this.p = Pattern.compile(sb.toString());
            }

            @Override
            public String getName() {
                return this.name + (this.ext.isEmpty() ? "" : "." + this.ext);
            }

            @Override
            public boolean accept(File f) {
                return this.p.matcher(f.getName()).matches();
            }

            @Override
            public ComparisonResult compare(FilterElement e) {
                if (e == null) {
                    throw new NullPointerException();
                }
                if (!(e instanceof NameBasedFilterElement)) {
                    return ComparisonResult.DIFFERENT;
                }
                NameBasedFilterElement x = (NameBasedFilterElement)e;
                if (this.name.equals(x.name) && this.ext.equals(x.ext)) {
                    if (this.substring == x.substring && this.ignoreCase == x.ignoreCase) {
                        return ComparisonResult.THE_SAME;
                    }
                    return this.compareFlags(x);
                }
                if (this.ext.equalsIgnoreCase(x.ext) && this.name.equalsIgnoreCase(x.name) && (this.ignoreCase || x.ignoreCase)) {
                    if (this.substring == x.substring && this.ignoreCase == x.ignoreCase) {
                        if (Character.isLowerCase(this.name.charAt(0))) {
                            return ComparisonResult.BETTER;
                        }
                        return ComparisonResult.WORSE;
                    }
                    return this.compareFlags(x);
                }
                return ComparisonResult.DIFFERENT;
            }

            private ComparisonResult compareFlags(NameBasedFilterElement x) {
                if (this.substring == x.substring && this.ignoreCase) {
                    return ComparisonResult.BETTER;
                }
                if (this.ignoreCase == x.ignoreCase && this.substring) {
                    return ComparisonResult.BETTER;
                }
                if (this.substring != x.substring && this.ignoreCase != x.ignoreCase) {
                    return ComparisonResult.DIFFERENT;
                }
                return ComparisonResult.WORSE;
            }
        }

        private static class ExtensionBasedFilterElement
        extends FilterElement {
            private final String extension;

            public ExtensionBasedFilterElement(String extension) {
                if (extension == null) {
                    throw new NullPointerException();
                }
                this.extension = extension;
            }

            @Override
            public String getName() {
                return "." + this.extension;
            }

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith("." + this.extension.toLowerCase());
            }

            @Override
            public ComparisonResult compare(FilterElement e) {
                if (!(e instanceof ExtensionBasedFilterElement)) {
                    return ComparisonResult.DIFFERENT;
                }
                ExtensionBasedFilterElement x = (ExtensionBasedFilterElement)e;
                if (x == null) {
                    throw new NullPointerException();
                }
                if (this.extension.equals(x.extension)) {
                    return ComparisonResult.THE_SAME;
                }
                if (this.extension.equalsIgnoreCase(x.extension) && this.extension.length() > 1) {
                    if (Character.isUpperCase(x.extension.charAt(0))) {
                        return ComparisonResult.BETTER;
                    }
                    return ComparisonResult.WORSE;
                }
                return ComparisonResult.DIFFERENT;
            }
        }

        public static enum ComparisonResult {
            THE_SAME,
            BETTER,
            WORSE,
            DIFFERENT;

        }
    }

    private static class FileFilterImpl
    extends FileFilter {
        private final String name;
        List<FilterElement> filterElements;

        public FileFilterImpl(String name, List<FilterElement> elements) {
            this.name = name;
            this.filterElements = elements;
        }

        @Override
        public boolean accept(File pathname) {
            return FileFilterSupport.accept(pathname, this.filterElements);
        }

        @Override
        public String getDescription() {
            return FileFilterSupport.constructFilterDisplayName(this.name, this.filterElements);
        }
    }
}

