/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.parser.UnitProcessor;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

class LengthNumberEvaluator
extends Evaluator {
    private short percentageInterpretation;
    private UnitProcessor.Context uctx;

    public LengthNumberEvaluator(short pcInterp, UnitProcessor.Context uctx) {
        super((short)3);
        this.percentageInterpretation = pcInterp;
        this.uctx = uctx;
    }

    protected CSSNumberValue absoluteTypedValue(CSSTypedValue typed) {
        if (typed.getPrimitiveType() == CSSValue.Type.NUMERIC) {
            short unitType = typed.getUnitType();
            if (CSSUnit.isRelativeLengthUnitType((short)unitType)) {
                float f = UnitProcessor.cssToUserSpace((float)typed.getFloatValue(), (short)unitType, (short)this.percentageInterpretation, (UnitProcessor.Context)this.uctx);
                return NumberValue.createCSSNumberValue((short)3, (float)f);
            }
            return (CSSNumberValue)typed;
        }
        throw new DOMInvalidAccessException("Unexpected value: " + typed.getCssText());
    }

    protected float percentage(CSSNumberValue typed, short resultType) throws DOMException {
        float f = UnitProcessor.cssToUserSpace((float)typed.getFloatValue((short)2), (short)2, (short)this.percentageInterpretation, (UnitProcessor.Context)this.uctx);
        return NumberValue.floatValueConversion((float)f, (short)3, (short)resultType);
    }
}

