/******************************************************************************
 *
 * Name:     gdal_multidim_cpp.h
 * Project:  GDAL Core
 * Purpose:  GDAL Core Multidimensional C++ declarations.
 * Author:   Even Rouault, <even dot rouault at spatialys.com>
 *
 ******************************************************************************
 * Copyright (c) 2025 Even Rouault <even dot rouault at spatialys.com>
 *
 * SPDX-License-Identifier: MIT
 ****************************************************************************/

#ifndef GDAL_MULTIDIM_CPP_H_INCLUDED
#define GDAL_MULTIDIM_CPP_H_INCLUDED

/**
 * \file gdal_multidim_cpp.h
 *
 * C++ GDAL multidimensional API entry points.
 *
 * Before GDAL 3.12, the equivalent file to include is gdal_priv.h (which still
 * exits in the GDAL 3.x series)
 *
 * \since GDAL 3.12
 */

#include "gdal_dataset.h"
#include "gdal_drivermanager.h"
#include "gdal_multidim.h"
#include "gdal_pam_multidim.h"

#endif
