/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFWArray;

public class PDFCIDFont
extends PDFObject {
    private String basefont;
    private CIDFontType cidtype;
    private Integer dw;
    private PDFWArray w;
    private int[] dw2;
    private PDFWArray w2;
    private PDFCIDSystemInfo systemInfo;
    private PDFCIDFontDescriptor descriptor;
    private PDFCMap cmap;
    private PDFStream cidMap;

    public PDFCIDFont(String basefont, CIDFontType cidtype, int dw, int[] w, String registry, String ordering, int supplement, PDFCIDFontDescriptor descriptor) {
        this(basefont, cidtype, dw, new PDFWArray(w), new PDFCIDSystemInfo(registry, ordering, supplement), descriptor);
    }

    public PDFCIDFont(String basefont, CIDFontType cidtype, int dw, int[] w, PDFCIDSystemInfo systemInfo, PDFCIDFontDescriptor descriptor) {
        this(basefont, cidtype, dw, new PDFWArray(w), systemInfo, descriptor);
    }

    public PDFCIDFont(String basefont, CIDFontType cidtype, int dw, PDFWArray w, PDFCIDSystemInfo systemInfo, PDFCIDFontDescriptor descriptor) {
        this.basefont = basefont;
        this.cidtype = cidtype;
        this.dw = dw;
        this.w = w;
        this.dw2 = null;
        this.w2 = null;
        systemInfo.setParent(this);
        this.systemInfo = systemInfo;
        this.descriptor = descriptor;
        this.cidMap = null;
        this.cmap = null;
    }

    public void setDW(int dw) {
        this.dw = dw;
    }

    public void setW(PDFWArray w) {
        this.w = w;
    }

    public void setDW2(int[] dw2) {
        this.dw2 = dw2;
    }

    public void setDW2(int posY, int displacementY) {
        this.dw2 = new int[]{posY, displacementY};
    }

    public void setCMAP(PDFCMap cmap) {
        this.cmap = cmap;
    }

    public void setW2(PDFWArray w2) {
        this.w2 = w2;
    }

    public void setCIDMap(PDFStream map) {
        this.cidMap = map;
    }

    public void setCIDMapIdentity() {
        this.cidMap = null;
    }

    protected String getPDFNameForCIDFontType(CIDFontType cidFontType) {
        if (cidFontType == CIDFontType.CIDTYPE0) {
            return cidFontType.getName();
        }
        if (cidFontType == CIDFontType.CIDTYPE2) {
            return cidFontType.getName();
        }
        throw new IllegalArgumentException("Unsupported CID font type: " + cidFontType.getName());
    }

    @Override
    public String toPDFString() {
        StringBuffer p = new StringBuffer(128);
        p.append("<< /Type /Font");
        p.append("\n/BaseFont /");
        p.append(this.basefont);
        p.append(" \n/CIDToGIDMap ");
        if (this.cidMap != null) {
            p.append(this.cidMap.referencePDF());
        } else {
            p.append("/Identity");
        }
        p.append(" \n/Subtype /");
        p.append(this.getPDFNameForCIDFontType(this.cidtype));
        p.append("\n");
        p.append(this.systemInfo.toPDFString());
        p.append("\n/FontDescriptor ");
        p.append(this.descriptor.referencePDF());
        if (this.cmap != null) {
            p.append("\n/ToUnicode ");
            p.append(this.cmap.referencePDF());
        }
        if (this.dw != null) {
            p.append("\n/DW ");
            p.append(this.dw);
        }
        if (this.w != null) {
            p.append("\n/W ");
            p.append(this.w.toPDFString());
        }
        if (this.dw2 != null) {
            p.append("\n/DW2 [");
            p.append(this.dw2[0]);
            p.append(this.dw2[1]);
            p.append("]");
        }
        if (this.w2 != null) {
            p.append("\n/W2 ");
            p.append(this.w2.toPDFString());
        }
        p.append("\n>>");
        return p.toString();
    }

    @Override
    public byte[] toPDF() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(128);
        try {
            bout.write(PDFCIDFont.encode("<< /Type /Font\n"));
            bout.write(PDFCIDFont.encode("/BaseFont /"));
            bout.write(PDFCIDFont.encode(this.basefont));
            bout.write(PDFCIDFont.encode(" \n"));
            bout.write(PDFCIDFont.encode("/CIDToGIDMap "));
            bout.write(PDFCIDFont.encode(this.cidMap != null ? this.cidMap.referencePDF() : "/Identity"));
            bout.write(PDFCIDFont.encode(" \n"));
            bout.write(PDFCIDFont.encode("/Subtype /"));
            bout.write(PDFCIDFont.encode(this.getPDFNameForCIDFontType(this.cidtype)));
            bout.write(PDFCIDFont.encode("\n"));
            bout.write(PDFCIDFont.encode("/CIDSystemInfo "));
            bout.write(this.systemInfo.toPDF());
            bout.write(PDFCIDFont.encode("\n"));
            bout.write(PDFCIDFont.encode("/FontDescriptor "));
            bout.write(PDFCIDFont.encode(this.descriptor.referencePDF()));
            bout.write(PDFCIDFont.encode("\n"));
            if (this.cmap != null) {
                bout.write(PDFCIDFont.encode("/ToUnicode "));
                bout.write(PDFCIDFont.encode(this.cmap.referencePDF()));
                bout.write(PDFCIDFont.encode("\n"));
            }
            if (this.dw != null) {
                bout.write(PDFCIDFont.encode("/DW "));
                bout.write(PDFCIDFont.encode(this.dw.toString()));
                bout.write(PDFCIDFont.encode("\n"));
            }
            if (this.w != null) {
                bout.write(PDFCIDFont.encode("/W "));
                bout.write(PDFCIDFont.encode(this.w.toPDFString()));
                bout.write(PDFCIDFont.encode("\n"));
            }
            if (this.dw2 != null) {
                bout.write(PDFCIDFont.encode("/DW2 ["));
                bout.write(PDFCIDFont.encode(Integer.toString(this.dw2[0])));
                bout.write(PDFCIDFont.encode(Integer.toString(this.dw2[1])));
                bout.write(PDFCIDFont.encode("]\n"));
            }
            if (this.w2 != null) {
                bout.write(PDFCIDFont.encode("/W2 "));
                bout.write(PDFCIDFont.encode(this.w2.toPDFString()));
                bout.write(PDFCIDFont.encode("\n"));
            }
            bout.write(PDFCIDFont.encode(">>"));
        }
        catch (IOException ioe) {
            log.error((Object)"Ignored I/O exception", (Throwable)ioe);
        }
        return bout.toByteArray();
    }

    @Override
    public void getChildren(Set<PDFObject> children) {
        super.getChildren(children);
        if (this.cidMap != null) {
            children.add(this.cidMap);
            this.cidMap.getChildren(children);
        }
        children.add(this.descriptor);
        this.descriptor.getChildren(children);
        if (this.cmap != null) {
            children.add(this.cmap);
            this.cmap.getChildren(children);
        }
    }
}

