/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WindowsDefenderConfigurator;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.LogOutputStream;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.core.DesktopPlatform;
import org.jkiss.dbeaver.core.DesktopUI;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPApplicationController;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.impl.app.BaseWorkspaceImpl;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.rcp.DesktopApplicationImpl;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.registry.SWTBrowserRegistry;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.runtime.ui.console.ConsoleUserInterface;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverCommandLine;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverSettingsImporter;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverWorkspaces;
import org.jkiss.dbeaver.ui.app.standalone.internal.WorkbenchPatcher;
import org.jkiss.dbeaver.ui.app.standalone.rpc.DBeaverInstanceServer;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.ui.app.standalone.update.VersionUpdateDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.osgi.framework.Version;

public class DBeaverApplication
extends DesktopApplicationImpl
implements DBPApplicationController {
    private static final Log log = Log.getLog(DBeaverApplication.class);
    public static final String APPLICATION_PLUGIN_ID = "org.jkiss.dbeaver.ui.app.standalone";
    public static final String WORKSPACE_DIR_LEGACY = "${user.home}/.dbeaver";
    public static final String WORKSPACE_DIR_4 = "${user.home}/.dbeaver4";
    public static final String[] WORKSPACE_DIR_PREVIOUS = new String[]{"${user.home}/.dbeaver4", "${user.home}/.dbeaver"};
    static final String VERSION_PROP_PRODUCT_NAME = "product-name";
    static final String VERSION_PROP_PRODUCT_VERSION = "product-version";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    public static final String DEFAULT_WORKSPACE_FOLDER = "workspace6";
    public static final String DEFAULT_WORKSPACES_FILE = ".workspaces";
    public static final String POLICY_WD_CHECK_SUPPRESS = "policy.wd.check.disabled";
    private static final String STARTUP_ACTIONS_FILE = "dbeaver-startup-actions.properties";
    private static final String RESET_USER_PREFERENCES = "reset_user_preferences";
    private static final String RESET_WORKSPACE_CONFIGURATION = "reset_workspace_configuration";
    private static final String DEFAULT_PROJECT_NAME = "General";
    private final Path FILE_WITH_WORKSPACES;
    private final Path WORKSPACE_DIR_CURRENT;
    static boolean WORKSPACE_MIGRATED = false;
    static DBeaverApplication instance;
    private boolean exclusiveMode = false;
    private boolean reuseWorkspace = false;
    private boolean primaryInstance = true;
    private boolean headlessMode = false;
    private DBeaverInstanceServer instanceServer;
    private OutputStream debugWriter;
    private PrintStream oldSystemOut;
    private PrintStream oldSystemErr;
    private Display display = null;
    private boolean resetUserPreferencesOnRestart;
    private boolean resetWorkspaceConfigurationOnRestart;
    private long lastUserActivityTime = -1L;

    public DBeaverApplication() {
        this("DBeaverData", DEFAULT_WORKSPACE_FOLDER, DEFAULT_WORKSPACES_FILE);
    }

    protected DBeaverApplication(String defaultWorkspaceLocation, String defaultAppWorkspaceName, String defaultWorkspacesFile) {
        String workingDirectory = RuntimeUtils.getWorkingDirectory((String)defaultWorkspaceLocation);
        this.WORKSPACE_DIR_CURRENT = Path.of(workingDirectory, new String[0]).resolve(defaultAppWorkspaceName);
        this.FILE_WITH_WORKSPACES = Paths.get(workingDirectory, defaultWorkspacesFile);
    }

    public static DBeaverApplication getInstance() {
        return instance;
    }

    public long getLastUserActivityTime() {
        return this.lastUserActivityTime;
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return DBeaverActivator.getInstance().getPreferences();
    }

    @NotNull
    public Object start(IApplicationContext context) {
        instance = this;
        String[] args = this.preprocessCommandLine();
        Location instanceLoc = Platform.getInstanceLocation();
        Path defaultHomePath = this.getDefaultInstanceLocation();
        boolean ideWorkspaceSet = this.setIDEWorkspace(instanceLoc);
        try {
            if (!instanceLoc.isSet() ? !this.setDefaultWorkspacePath(instanceLoc) : instanceLoc.isLocked() && !ideWorkspaceSet && !this.isExclusiveMode() && !this.setDefaultWorkspacePath(instanceLoc)) {
                return IApplication.EXIT_OK;
            }
            if (this.isExclusiveMode()) {
                this.markLocationReadOnly(instanceLoc);
            } else if (!instanceLoc.isLocked()) {
                instanceLoc.lock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadStartupActions(instanceLoc);
        this.initializeApplicationServices();
        try {
            this.headlessMode = true;
            try {
                CLIProcessResult cliProcessResult = DBeaverCommandLine.getInstance().executeCommandLineCommands(null, false, false, args);
                if (cliProcessResult.getPostAction() == CLIProcessResult.PostAction.SHUTDOWN) {
                    if (!CommonUtils.isEmpty((Collection)cliProcessResult.getOutput())) {
                        for (String res : cliProcessResult.getOutput()) {
                            System.out.println(res);
                        }
                    }
                    Integer n = IApplication.EXIT_OK;
                    return n;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error processing command line parameters", (Throwable)e);
                Integer n = IApplication.EXIT_OK;
                this.headlessMode = false;
                return n;
            }
        }
        finally {
            this.headlessMode = false;
        }
        if (this.isExclusiveMode()) {
            return IApplication.EXIT_OK;
        }
        Runtime runtime = Runtime.getRuntime();
        this.initializeConfiguration();
        this.initDebugWriter();
        log.debug((Object)(GeneralUtils.getProductName() + " " + String.valueOf(GeneralUtils.getProductVersion()) + " is starting"));
        log.debug((Object)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")"));
        log.debug((Object)("Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor") + " (" + System.getProperty("sun.arch.data.model") + "bit)"));
        log.debug((Object)("Install path: '" + SystemVariablesResolver.getInstallPath() + "'"));
        log.debug((Object)("Instance path: '" + String.valueOf(instanceLoc.getURL()) + "'"));
        log.debug((Object)("Memory available " + runtime.totalMemory() / 0x100000L + "Mb/" + runtime.maxMemory() / 0x100000L + "Mb"));
        this.writeWorkspaceInfo();
        this.getDisplay();
        this.updateSplashHandler();
        if (RuntimeUtils.isWindows() && this.isStandalone()) {
            SWTBrowserRegistry.overrideBrowser();
        }
        DBWorkbench.getPlatform();
        if (!this.isWorkspaceSwitchingAllowed() && !this.WORKSPACE_DIR_CURRENT.equals(defaultHomePath)) {
            log.error((Object)("Workspace switching is not allowed when participating in the early access program. Exiting " + GeneralUtils.getProductName() + "."));
            return IApplication.EXIT_OK;
        }
        WorkbenchPatcher.patchWorkbenchXmi(instanceLoc);
        try {
            this.initializeApplication();
        }
        catch (DBException e) {
            this.showMessageBox("Error initializing application", e.getMessage(), 1);
            log.error((Object)e);
            return IApplication.EXIT_OK;
        }
        try {
            this.instanceServer = DBeaverInstanceServer.createServer();
        }
        catch (Exception e) {
            log.error((Object)("Can't start instance server: " + e.getMessage()));
        }
        TimezoneRegistry.overrideTimezone();
        if (CommonUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore")) && CommonUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType"))) {
            DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            if (RuntimeUtils.isWindows() && preferenceStore.getBoolean("connections.useWinTrustStoreType")) {
                System.setProperty("javax.net.ssl.trustStoreType", "WINDOWS-ROOT");
            }
        }
        PlatformUI.getPreferenceStore().setDefault("KEY_CONFIGURATION_ID", "org.jkiss.dbeaver.defaultKeyScheme");
        try {
            log.debug((Object)"Run workbench");
            int returnCode = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)this.createWorkbenchAdvisor());
            if (returnCode != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        catch (Throwable e) {
            log.debug((Object)"Internal error in workbench lifecycle", e);
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            this.shutdown();
            this.display.dispose();
            this.display = null;
        }
    }

    private String[] preprocessCommandLine() {
        Object[] args;
        Object[] objectArray = args = Platform.getApplicationArgs();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = objectArray[n2];
            if (arg.equals("-reuseWorkspace")) {
                this.reuseWorkspace = true;
                args = (String[])ArrayUtils.remove(String.class, (Object[])args, (Object)arg);
                break;
            }
            ++n2;
        }
        try {
            args = DBeaverCommandLine.getInstance().preprocessCommandLine((String[])args);
        }
        catch (DBException e) {
            log.error((Object)"Error preprocessing command line", (Throwable)e);
        }
        return args;
    }

    private void markLocationReadOnly(Location instanceLoc) {
        try {
            Field isReadOnlyField = instanceLoc.getClass().getDeclaredField("isReadOnly");
            isReadOnlyField.setAccessible(true);
            isReadOnlyField.set(instanceLoc, true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private boolean setIDEWorkspace(@NotNull Location instanceLoc) {
        if (instanceLoc.isSet()) {
            return false;
        }
        if (!this.isWorkspaceSwitchingAllowed()) {
            return false;
        }
        String lastWorkspace = DBeaverWorkspaces.fetchRecentWorkspaces(this, instanceLoc).getFirst();
        if (!CommonUtils.isEmpty((String)lastWorkspace)) {
            try {
                Path lwPath = Path.of(lastWorkspace, new String[0]);
                if (!this.WORKSPACE_DIR_CURRENT.equals(lwPath)) {
                    URL selectedWorkspaceURL = lwPath.toUri().toURL();
                    instanceLoc.set(selectedWorkspaceURL, true);
                    return true;
                }
            }
            catch (Exception e) {
                log.debug((Object)("Can't set IDE workspace to '" + lastWorkspace + "'"), (Throwable)e);
            }
        }
        return false;
    }

    @NotNull
    public Path getWorkspacesFile() {
        return this.FILE_WITH_WORKSPACES;
    }

    @NotNull
    public Path getDefaultWorkingFolder() {
        return this.WORKSPACE_DIR_CURRENT;
    }

    @NotNull
    public Class<? extends DBPPlatform> getPlatformClass() {
        return DesktopPlatform.class;
    }

    public Class<? extends DBPPlatformUI> getPlatformUIClass() {
        return this.isHeadlessMode() ? ConsoleUserInterface.class : DesktopUI.class;
    }

    public Path getDefaultInstanceLocation() {
        Path defaultHomePath = this.WORKSPACE_DIR_CURRENT;
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc.isSet()) {
            try {
                defaultHomePath = RuntimeUtils.getLocalFileFromURL((URL)instanceLoc.getURL());
            }
            catch (IOException e) {
                System.err.println("Unable to resolve workspace location " + String.valueOf(instanceLoc));
                e.printStackTrace();
            }
        }
        return defaultHomePath;
    }

    private void updateSplashHandler() {
        if (ArrayUtils.contains((Object[])Platform.getApplicationArgs(), (Object)"-nosplash")) {
            return;
        }
        try {
            Shell shell = WorkbenchPlugin.getSplashShell((Display)this.display);
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Window.getDefaultImages());
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.err.println("Error updating splash shell");
        }
    }

    protected void initializeConfiguration() {
        boolean debugNetworkConnections;
        ModelPreferences.IPType address;
        ModelPreferences.IPType stack = ModelPreferences.IPType.getPreferredStack();
        if (stack != ModelPreferences.IPType.AUTO) {
            System.setProperty("java.net.preferIPv4Stack", String.valueOf(stack == ModelPreferences.IPType.IPV4));
        }
        if ((address = ModelPreferences.IPType.getPreferredAddresses()) != ModelPreferences.IPType.AUTO) {
            System.setProperty("java.net.preferIPv6Addresses", String.valueOf(address == ModelPreferences.IPType.IPV6));
        }
        if (debugNetworkConnections = ModelPreferences.getPreferences().getBoolean("connections.debugNetworkConnections")) {
            System.setProperty("javax.net.debug", "all");
        }
    }

    protected void initializeApplication() throws DBException {
        DBeaverApplication.activateProxyService();
        if (ApplicationPolicyProvider.getInstance().isPolicyEnabled(POLICY_WD_CHECK_SUPPRESS)) {
            try {
                WindowsDefenderConfigurator.savePreference((IScopeContext)ConfigurationScope.INSTANCE, (String)"windows.defender.startup.check.skip", (String)"true");
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
    }

    private static void activateProxyService() {
        try {
            log.debug((Object)("Proxy service '" + IProxyService.class.getName() + "' loaded"));
        }
        catch (Throwable throwable) {
            log.debug((Object)"Proxy service not found");
        }
    }

    private Display getDisplay() {
        if (this.display == null) {
            log.debug((Object)"Create display");
            Display.setAppName((String)GeneralUtils.getProductName());
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = PlatformUI.createDisplay();
            }
            Resource.setNonDisposeHandler(originStack -> log.warn((Object)"SWT resource leak detected", (Throwable)originStack));
            this.addIdleListeners();
        }
        return this.display;
    }

    private void addIdleListeners() {
        int[] events = new int[]{1, 2, 3, 5, 4, 37};
        Listener idleListener = event -> {
            long l = this.lastUserActivityTime = System.currentTimeMillis();
        };
        int[] nArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            int event2 = nArray[n2];
            this.display.addFilter(event2, idleListener);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setDefaultWorkspacePath(Location instanceLoc) {
        Path defaultHomePath = this.WORKSPACE_DIR_CURRENT;
        try {
            if (!(Files.exists(defaultHomePath, new LinkOption[0]) && !DBeaverApplication.isEmptyFolder(defaultHomePath) || this.tryMigrateFromPreviousVersion(defaultHomePath))) {
                return false;
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error migrating old workspace version", e);
        }
        try {
            URL defaultHomeURL = defaultHomePath.toUri().toURL();
            boolean keepTrying = true;
            while (keepTrying) {
                if (!instanceLoc.isLocked()) {
                    if (instanceLoc.set(defaultHomeURL, true)) return true;
                }
                if (this.exclusiveMode || this.reuseWorkspace) {
                    instanceLoc.set(defaultHomeURL, false);
                    keepTrying = false;
                    this.primaryInstance = false;
                    continue;
                }
                int msgResult = this.showMessageBox("DBeaver - Can't lock workspace", "Can't lock workspace at " + String.valueOf(defaultHomePath) + ".\nIt seems that you have another DBeaver instance running.\nYou may ignore it and work without lock but it is recommended to shutdown previous instance otherwise you may corrupt workspace data.", 3592);
                switch (msgResult) {
                    case 512: {
                        return false;
                    }
                    case 2048: {
                        instanceLoc.set(defaultHomeURL, false);
                        keepTrying = false;
                        this.primaryInstance = false;
                        break;
                    }
                }
            }
            return true;
        }
        catch (Throwable e) {
            System.err.println("Can't switch workspace to '" + String.valueOf(defaultHomePath) + "' - " + e.getMessage());
        }
        return true;
    }

    private static boolean isEmptyFolder(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> list = Files.list(path);){
            return list.findAny().isEmpty();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected boolean tryMigrateFromPreviousVersion(Path homeDir) {
        Path previousVersionWorkspaceDir = null;
        String[] stringArray = WORKSPACE_DIR_PREVIOUS;
        int n = WORKSPACE_DIR_PREVIOUS.length;
        int n2 = 0;
        while (n2 < n) {
            String oldDir = stringArray[n2];
            Path oldWorkspaceDir = Path.of(oldDir = GeneralUtils.replaceSystemPropertyVariables((String)oldDir), new String[0]);
            if (Files.exists(oldWorkspaceDir, new LinkOption[0]) && Files.exists(GeneralUtils.getMetadataFolder((Path)oldWorkspaceDir), new LinkOption[0])) {
                previousVersionWorkspaceDir = oldWorkspaceDir;
                break;
            }
            ++n2;
        }
        if (previousVersionWorkspaceDir != null) {
            DBeaverSettingsImporter importer = new DBeaverSettingsImporter(this, this.getDisplay());
            return importer.migrateFromPreviousVersion(previousVersionWorkspaceDir.toFile(), homeDir.toFile());
        }
        return true;
    }

    private void writeWorkspaceInfo() {
        Path defaultDir = this.getDefaultWorkingFolder();
        Path metadataFolder = defaultDir.resolve(".metadata");
        if (!Files.exists(metadataFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(metadataFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Error creating metadata folder '" + String.valueOf(metadataFolder) + "': " + e.getMessage());
            }
        }
        Properties props = BaseWorkspaceImpl.readWorkspaceInfo((Path)metadataFolder);
        props.setProperty(VERSION_PROP_PRODUCT_NAME, GeneralUtils.getProductName());
        props.setProperty(VERSION_PROP_PRODUCT_VERSION, GeneralUtils.getProductVersion().toString());
        BaseWorkspaceImpl.writeWorkspaceInfo((Path)metadataFolder, (Properties)props);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new ApplicationWorkbenchAdvisor((DBPApplication)this);
    }

    public void stop() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }

    private void shutdown() {
        log.debug((Object)"DBeaver is stopping");
        this.saveStartupActions();
        Location location = Platform.getInstanceLocation();
        if (location.isSet()) {
            DBeaverWorkspaces.flushRecentWorkspaces(this, location);
        }
        try {
            try {
                DBeaverInstanceServer server = this.instanceServer;
                if (server != null) {
                    this.instanceServer = null;
                    RuntimeUtils.runTask(monitor -> server.stopInstanceServer(), (String)"Stop instance server", (long)1000L);
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
                instance = null;
                log.debug((Object)"DBeaver shutdown completed");
                this.stopDebugWriter();
            }
        }
        finally {
            instance = null;
            log.debug((Object)"DBeaver shutdown completed");
            this.stopDebugWriter();
        }
    }

    private void initDebugWriter() {
        DBPPreferenceStore preferenceStore = DBeaverActivator.getInstance().getPreferences();
        if (!preferenceStore.getBoolean("logs.debug.enabled")) {
            return;
        }
        String logLocation = preferenceStore.getString("logs.debug.location");
        if (CommonUtils.isEmpty((String)logLocation)) {
            logLocation = GeneralUtils.getMetadataFolder().resolve("dbeaver-debug.log").toAbsolutePath().toString();
        }
        logLocation = GeneralUtils.replaceVariables((String)logLocation, (IVariableResolver)new SystemVariablesResolver());
        File debugLogFile = new File(logLocation);
        try {
            this.debugWriter = new LogOutputStream(debugLogFile);
            this.oldSystemOut = System.out;
            this.oldSystemErr = System.err;
            System.setOut(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemOut)));
            System.setErr(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemErr)));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void stopDebugWriter() {
        if (this.oldSystemOut != null) {
            System.setOut(this.oldSystemOut);
        }
        if (this.oldSystemErr != null) {
            System.setErr(this.oldSystemErr);
        }
        if (this.debugWriter != null) {
            IOUtils.close((Closeable)this.debugWriter);
            this.debugWriter = null;
        }
    }

    @Nullable
    public IInstanceController getInstanceServer() {
        return this.instanceServer;
    }

    @Nullable
    public IInstanceController createInstanceClient() {
        return DBeaverInstanceServer.createClient(this.getDefaultInstanceLocation());
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isCommunity() {
        return true;
    }

    public boolean isPrimaryInstance() {
        return this.primaryInstance && !this.isHeadlessMode();
    }

    public boolean isHeadlessMode() {
        return this.headlessMode;
    }

    public boolean isExclusiveMode() {
        return this.exclusiveMode;
    }

    public void setExclusiveMode(boolean exclusiveMode) {
        this.exclusiveMode = exclusiveMode;
    }

    public boolean isReuseWorkspace() {
        return this.reuseWorkspace;
    }

    public void setReuseWorkspace(boolean reuseWorkspace) {
        this.reuseWorkspace = reuseWorkspace;
    }

    public void setHeadlessMode(boolean headlessMode) {
        this.headlessMode = headlessMode;
    }

    public String getInfoDetails() {
        return null;
    }

    @Nullable
    public String getDefaultProjectName() {
        return DEFAULT_PROJECT_NAME;
    }

    private int showMessageBox(@NotNull String title, String message, int style) {
        Shell shell = new Shell(this.getDisplay(), 16384);
        shell.setText(GeneralUtils.getProductTitle());
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        int msgResult = messageBox.open();
        shell.dispose();
        return msgResult;
    }

    public void notifyVersionUpgrade(@NotNull Version currentVersion, @NotNull VersionDescriptor newVersion, boolean showSkip) {
        VersionUpdateDialog dialog = new VersionUpdateDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), currentVersion, newVersion, showSkip);
        dialog.open();
    }

    public void setResetUserPreferencesOnRestart(boolean resetUserPreferencesOnRestart) {
        this.resetUserPreferencesOnRestart = resetUserPreferencesOnRestart;
    }

    public void setResetWorkspaceConfigurationOnRestart(boolean resetWorkspaceConfigurationOnRestart) {
        this.resetWorkspaceConfigurationOnRestart = resetWorkspaceConfigurationOnRestart;
    }

    private void saveStartupActions() {
        Properties props = new Properties();
        if (this.resetWorkspaceConfigurationOnRestart) {
            props.setProperty(RESET_WORKSPACE_CONFIGURATION, Boolean.TRUE.toString());
        }
        if (this.resetUserPreferencesOnRestart) {
            props.setProperty(RESET_USER_PREFERENCES, Boolean.TRUE.toString());
        }
        if (!props.isEmpty()) {
            Path path = GeneralUtils.getMetadataFolder().resolve(STARTUP_ACTIONS_FILE);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    props.store(writer, "DBeaver startup actions");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to save startup actions", (Throwable)e);
            }
        }
    }

    private void loadStartupActions(@NotNull Location instanceLoc) {
        Path actionsPath;
        Path instancePath;
        try {
            instancePath = RuntimeUtils.getLocalPathFromURL((URL)instanceLoc.getURL()).resolve(".metadata");
            actionsPath = instancePath.resolve(STARTUP_ACTIONS_FILE);
        }
        catch (Exception exception) {
            return;
        }
        if (Files.notExists(actionsPath, new LinkOption[0])) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedReader reader = Files.newBufferedReader(actionsPath);){
                    Properties properties = new Properties();
                    properties.load(reader);
                    if (!properties.isEmpty()) {
                        this.processStartupActions(instancePath, properties.stringPropertyNames());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to read startup actions", (Throwable)e);
                try {
                    Files.delete(actionsPath);
                }
                catch (IOException e2) {
                    log.error((Object)("Unable to delete startup actions file: " + e2.getMessage()));
                }
            }
        }
        finally {
            try {
                Files.delete(actionsPath);
            }
            catch (IOException e) {
                log.error((Object)("Unable to delete startup actions file: " + e.getMessage()));
            }
        }
    }

    private void processStartupActions(@NotNull Path instancePath, @NotNull Set<String> actions) throws Exception {
        final boolean resetUserPreferences = actions.contains(RESET_USER_PREFERENCES);
        final boolean resetWorkspaceConfiguration = actions.contains(RESET_WORKSPACE_CONFIGURATION);
        if (!resetUserPreferences && !resetWorkspaceConfiguration) {
            return;
        }
        final Path path = instancePath.resolve(".plugins");
        if (Files.notExists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @NotNull
            public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) {
                log.trace((Object)("Deleting " + String.valueOf(file)));
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    log.trace((Object)("Unable to delete " + String.valueOf(file) + ":" + e.getMessage()));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            @NotNull
            public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
                if (dir.endsWith(".plugins")) {
                    return FileVisitResult.CONTINUE;
                }
                Path relative = path.relativize(dir);
                if (resetUserPreferences && !relative.startsWith("org.eclipse.core.resources")) {
                    return FileVisitResult.CONTINUE;
                }
                if (resetWorkspaceConfiguration && relative.startsWith("org.eclipse.core.resources")) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            @NotNull
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                log.trace((Object)("Deleting " + String.valueOf(dir)));
                try {
                    Files.delete(dir);
                }
                catch (IOException e) {
                    log.trace((Object)("Unable to delete " + String.valueOf(dir) + ":" + e.getMessage()));
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static class ProxyPrintStream
    extends OutputStream {
        private final OutputStream debugWriter;
        private final OutputStream stdOut;

        ProxyPrintStream(OutputStream debugWriter, OutputStream stdOut) {
            this.debugWriter = debugWriter;
            this.stdOut = stdOut;
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.debugWriter.write(b);
            this.stdOut.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.debugWriter.write(b, off, len);
            this.stdOut.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.debugWriter.write(b);
            this.stdOut.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.debugWriter.flush();
            this.stdOut.flush();
        }
    }
}

