/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.oauth.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.oauth.IOAuthHandler;
import org.jkiss.utils.oauth.client.OAuthRequestPostBuilder;

public class OAuthClientCredentialsHandler
implements IOAuthHandler {
    protected static final Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).setPrettyPrinting().create();
    @NotNull
    protected final String clientId;
    @Nullable
    protected final String secretId;
    @NotNull
    protected final String authUrl;
    protected int timeout = 120;

    public OAuthClientCredentialsHandler(@NotNull String clientId, @Nullable String secretId, @NotNull String authUrl) {
        this.clientId = clientId;
        this.secretId = secretId;
        this.authUrl = authUrl;
    }

    @Override
    public Map<String, String> authorize() throws IOException {
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(120L)).build();
        OAuthRequestPostBuilder requestBuilder = new OAuthRequestPostBuilder(this.authUrl).withClientId(this.clientId).withClientSecret(this.secretId).withGrantType("client_credentials");
        HttpResponse<String> response = null;
        try {
            response = client.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException e) {
            throw new IOException("Authorization request interrupted", e);
        }
        return this.extractResponse(response);
    }

    protected Map<String, String> extractResponse(HttpResponse<String> response) throws IOException {
        JsonObject jsonObject = JsonParser.parseString((String)response.body()).getAsJsonObject();
        String idToken = jsonObject.get("id_token").getAsString();
        if (idToken != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("token", idToken);
            return result;
        }
        throw new IOException("Error extracting token");
    }
}

