﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/FilterExpression.h>
#include <aws/glue/model/FilterLogicalOperator.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>Specifies a transform that splits a dataset into two, based on a filter
 * condition.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Filter">AWS API
 * Reference</a></p>
 */
class Filter {
 public:
  AWS_GLUE_API Filter() = default;
  AWS_GLUE_API Filter(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Filter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the transform node.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Filter& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data inputs identified by their node names.</p>
   */
  inline const Aws::Vector<Aws::String>& GetInputs() const { return m_inputs; }
  inline bool InputsHasBeenSet() const { return m_inputsHasBeenSet; }
  template <typename InputsT = Aws::Vector<Aws::String>>
  void SetInputs(InputsT&& value) {
    m_inputsHasBeenSet = true;
    m_inputs = std::forward<InputsT>(value);
  }
  template <typename InputsT = Aws::Vector<Aws::String>>
  Filter& WithInputs(InputsT&& value) {
    SetInputs(std::forward<InputsT>(value));
    return *this;
  }
  template <typename InputsT = Aws::String>
  Filter& AddInputs(InputsT&& value) {
    m_inputsHasBeenSet = true;
    m_inputs.emplace_back(std::forward<InputsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The operator used to filter rows by comparing the key value to a specified
   * value.</p>
   */
  inline FilterLogicalOperator GetLogicalOperator() const { return m_logicalOperator; }
  inline bool LogicalOperatorHasBeenSet() const { return m_logicalOperatorHasBeenSet; }
  inline void SetLogicalOperator(FilterLogicalOperator value) {
    m_logicalOperatorHasBeenSet = true;
    m_logicalOperator = value;
  }
  inline Filter& WithLogicalOperator(FilterLogicalOperator value) {
    SetLogicalOperator(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies a filter expression.</p>
   */
  inline const Aws::Vector<FilterExpression>& GetFilters() const { return m_filters; }
  inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
  template <typename FiltersT = Aws::Vector<FilterExpression>>
  void SetFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters = std::forward<FiltersT>(value);
  }
  template <typename FiltersT = Aws::Vector<FilterExpression>>
  Filter& WithFilters(FiltersT&& value) {
    SetFilters(std::forward<FiltersT>(value));
    return *this;
  }
  template <typename FiltersT = FilterExpression>
  Filter& AddFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters.emplace_back(std::forward<FiltersT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::Vector<Aws::String> m_inputs;

  FilterLogicalOperator m_logicalOperator{FilterLogicalOperator::NOT_SET};

  Aws::Vector<FilterExpression> m_filters;
  bool m_nameHasBeenSet = false;
  bool m_inputsHasBeenSet = false;
  bool m_logicalOperatorHasBeenSet = false;
  bool m_filtersHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
