﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/voice-id/VoiceIDRequest.h>
#include <aws/voice-id/VoiceID_EXPORTS.h>

#include <utility>

namespace Aws {
namespace VoiceID {
namespace Model {

/**
 */
class DescribeSpeakerRequest : public VoiceIDRequest {
 public:
  AWS_VOICEID_API DescribeSpeakerRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeSpeaker"; }

  AWS_VOICEID_API Aws::String SerializePayload() const override;

  AWS_VOICEID_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the domain that contains the speaker.</p>
   */
  inline const Aws::String& GetDomainId() const { return m_domainId; }
  inline bool DomainIdHasBeenSet() const { return m_domainIdHasBeenSet; }
  template <typename DomainIdT = Aws::String>
  void SetDomainId(DomainIdT&& value) {
    m_domainIdHasBeenSet = true;
    m_domainId = std::forward<DomainIdT>(value);
  }
  template <typename DomainIdT = Aws::String>
  DescribeSpeakerRequest& WithDomainId(DomainIdT&& value) {
    SetDomainId(std::forward<DomainIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the speaker you are describing.</p>
   */
  inline const Aws::String& GetSpeakerId() const { return m_speakerId; }
  inline bool SpeakerIdHasBeenSet() const { return m_speakerIdHasBeenSet; }
  template <typename SpeakerIdT = Aws::String>
  void SetSpeakerId(SpeakerIdT&& value) {
    m_speakerIdHasBeenSet = true;
    m_speakerId = std::forward<SpeakerIdT>(value);
  }
  template <typename SpeakerIdT = Aws::String>
  DescribeSpeakerRequest& WithSpeakerId(SpeakerIdT&& value) {
    SetSpeakerId(std::forward<SpeakerIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainId;

  Aws::String m_speakerId;
  bool m_domainIdHasBeenSet = false;
  bool m_speakerIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace VoiceID
}  // namespace Aws
