﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/client/GenericClientConfiguration.h>
#include <aws/core/endpoint/DefaultEndpointProvider.h>
#include <aws/core/endpoint/EndpointParameter.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/transcribe/TranscribeServiceEndpointRules.h>
#include <aws/transcribe/TranscribeService_EXPORTS.h>

namespace Aws {
namespace TranscribeService {
namespace Endpoint {
using EndpointParameters = Aws::Endpoint::EndpointParameters;
using Aws::Endpoint::DefaultEndpointProvider;
using Aws::Endpoint::EndpointProviderBase;

using TranscribeServiceClientContextParameters = Aws::Endpoint::ClientContextParameters;

using TranscribeServiceClientConfiguration = Aws::Client::GenericClientConfiguration;
using TranscribeServiceBuiltInParameters = Aws::Endpoint::BuiltInParameters;

/**
 * The type for the TranscribeService Client Endpoint Provider.
 * Inherit from this Base class / "Interface" should you want to provide a custom endpoint provider.
 * The SDK must use service-specific type for each service per specification.
 */
using TranscribeServiceEndpointProviderBase = EndpointProviderBase<TranscribeServiceClientConfiguration, TranscribeServiceBuiltInParameters,
                                                                   TranscribeServiceClientContextParameters>;

using TranscribeServiceDefaultEpProviderBase =
    DefaultEndpointProvider<TranscribeServiceClientConfiguration, TranscribeServiceBuiltInParameters,
                            TranscribeServiceClientContextParameters>;

/**
 * Default endpoint provider used for this service
 */
class AWS_TRANSCRIBESERVICE_API TranscribeServiceEndpointProvider : public TranscribeServiceDefaultEpProviderBase {
 public:
  using TranscribeServiceResolveEndpointOutcome = Aws::Endpoint::ResolveEndpointOutcome;

  TranscribeServiceEndpointProvider()
      : TranscribeServiceDefaultEpProviderBase(Aws::TranscribeService::TranscribeServiceEndpointRules::GetRulesBlob(),
                                               Aws::TranscribeService::TranscribeServiceEndpointRules::RulesBlobSize) {}

  ~TranscribeServiceEndpointProvider() {}
};
}  // namespace Endpoint
}  // namespace TranscribeService
}  // namespace Aws
