﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53resolver/Route53Resolver_EXPORTS.h>
#include <aws/route53resolver/model/FirewallRuleGroupAssociationStatus.h>
#include <aws/route53resolver/model/MutationProtectionStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Route53Resolver {
namespace Model {

/**
 * <p>An association between a firewall rule group and a VPC, which enables DNS
 * filtering for the VPC. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/FirewallRuleGroupAssociation">AWS
 * API Reference</a></p>
 */
class FirewallRuleGroupAssociation {
 public:
  AWS_ROUTE53RESOLVER_API FirewallRuleGroupAssociation() = default;
  AWS_ROUTE53RESOLVER_API FirewallRuleGroupAssociation(Aws::Utils::Json::JsonView jsonValue);
  AWS_ROUTE53RESOLVER_API FirewallRuleGroupAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ROUTE53RESOLVER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier for the association.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  FirewallRuleGroupAssociation& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the firewall rule group association.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  FirewallRuleGroupAssociation& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the firewall rule group. </p>
   */
  inline const Aws::String& GetFirewallRuleGroupId() const { return m_firewallRuleGroupId; }
  inline bool FirewallRuleGroupIdHasBeenSet() const { return m_firewallRuleGroupIdHasBeenSet; }
  template <typename FirewallRuleGroupIdT = Aws::String>
  void SetFirewallRuleGroupId(FirewallRuleGroupIdT&& value) {
    m_firewallRuleGroupIdHasBeenSet = true;
    m_firewallRuleGroupId = std::forward<FirewallRuleGroupIdT>(value);
  }
  template <typename FirewallRuleGroupIdT = Aws::String>
  FirewallRuleGroupAssociation& WithFirewallRuleGroupId(FirewallRuleGroupIdT&& value) {
    SetFirewallRuleGroupId(std::forward<FirewallRuleGroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the VPC that is associated with the rule group. </p>
   */
  inline const Aws::String& GetVpcId() const { return m_vpcId; }
  inline bool VpcIdHasBeenSet() const { return m_vpcIdHasBeenSet; }
  template <typename VpcIdT = Aws::String>
  void SetVpcId(VpcIdT&& value) {
    m_vpcIdHasBeenSet = true;
    m_vpcId = std::forward<VpcIdT>(value);
  }
  template <typename VpcIdT = Aws::String>
  FirewallRuleGroupAssociation& WithVpcId(VpcIdT&& value) {
    SetVpcId(std::forward<VpcIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the association.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  FirewallRuleGroupAssociation& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The setting that determines the processing order of the rule group among the
   * rule groups that are associated with a single VPC. DNS Firewall filters VPC
   * traffic starting from rule group with the lowest numeric priority setting. </p>
   */
  inline int GetPriority() const { return m_priority; }
  inline bool PriorityHasBeenSet() const { return m_priorityHasBeenSet; }
  inline void SetPriority(int value) {
    m_priorityHasBeenSet = true;
    m_priority = value;
  }
  inline FirewallRuleGroupAssociation& WithPriority(int value) {
    SetPriority(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If enabled, this setting disallows modification or removal of the
   * association, to help prevent against accidentally altering DNS firewall
   * protections. </p>
   */
  inline MutationProtectionStatus GetMutationProtection() const { return m_mutationProtection; }
  inline bool MutationProtectionHasBeenSet() const { return m_mutationProtectionHasBeenSet; }
  inline void SetMutationProtection(MutationProtectionStatus value) {
    m_mutationProtectionHasBeenSet = true;
    m_mutationProtection = value;
  }
  inline FirewallRuleGroupAssociation& WithMutationProtection(MutationProtectionStatus value) {
    SetMutationProtection(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The owner of the association, used only for associations that are not managed
   * by you. If you use Firewall Manager to manage your DNS Firewalls, then this
   * reports Firewall Manager as the managed owner.</p>
   */
  inline const Aws::String& GetManagedOwnerName() const { return m_managedOwnerName; }
  inline bool ManagedOwnerNameHasBeenSet() const { return m_managedOwnerNameHasBeenSet; }
  template <typename ManagedOwnerNameT = Aws::String>
  void SetManagedOwnerName(ManagedOwnerNameT&& value) {
    m_managedOwnerNameHasBeenSet = true;
    m_managedOwnerName = std::forward<ManagedOwnerNameT>(value);
  }
  template <typename ManagedOwnerNameT = Aws::String>
  FirewallRuleGroupAssociation& WithManagedOwnerName(ManagedOwnerNameT&& value) {
    SetManagedOwnerName(std::forward<ManagedOwnerNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the association.</p>
   */
  inline FirewallRuleGroupAssociationStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(FirewallRuleGroupAssociationStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline FirewallRuleGroupAssociation& WithStatus(FirewallRuleGroupAssociationStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Additional information about the status of the response, if available.</p>
   */
  inline const Aws::String& GetStatusMessage() const { return m_statusMessage; }
  inline bool StatusMessageHasBeenSet() const { return m_statusMessageHasBeenSet; }
  template <typename StatusMessageT = Aws::String>
  void SetStatusMessage(StatusMessageT&& value) {
    m_statusMessageHasBeenSet = true;
    m_statusMessage = std::forward<StatusMessageT>(value);
  }
  template <typename StatusMessageT = Aws::String>
  FirewallRuleGroupAssociation& WithStatusMessage(StatusMessageT&& value) {
    SetStatusMessage(std::forward<StatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique string defined by you to identify the request. This allows you to
   * retry failed requests without the risk of running the operation twice. This can
   * be any unique string, for example, a timestamp. </p>
   */
  inline const Aws::String& GetCreatorRequestId() const { return m_creatorRequestId; }
  inline bool CreatorRequestIdHasBeenSet() const { return m_creatorRequestIdHasBeenSet; }
  template <typename CreatorRequestIdT = Aws::String>
  void SetCreatorRequestId(CreatorRequestIdT&& value) {
    m_creatorRequestIdHasBeenSet = true;
    m_creatorRequestId = std::forward<CreatorRequestIdT>(value);
  }
  template <typename CreatorRequestIdT = Aws::String>
  FirewallRuleGroupAssociation& WithCreatorRequestId(CreatorRequestIdT&& value) {
    SetCreatorRequestId(std::forward<CreatorRequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that the association was created, in Unix time format and
   * Coordinated Universal Time (UTC). </p>
   */
  inline const Aws::String& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::String>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::String>
  FirewallRuleGroupAssociation& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that the association was last modified, in Unix time format
   * and Coordinated Universal Time (UTC).</p>
   */
  inline const Aws::String& GetModificationTime() const { return m_modificationTime; }
  inline bool ModificationTimeHasBeenSet() const { return m_modificationTimeHasBeenSet; }
  template <typename ModificationTimeT = Aws::String>
  void SetModificationTime(ModificationTimeT&& value) {
    m_modificationTimeHasBeenSet = true;
    m_modificationTime = std::forward<ModificationTimeT>(value);
  }
  template <typename ModificationTimeT = Aws::String>
  FirewallRuleGroupAssociation& WithModificationTime(ModificationTimeT&& value) {
    SetModificationTime(std::forward<ModificationTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_arn;

  Aws::String m_firewallRuleGroupId;

  Aws::String m_vpcId;

  Aws::String m_name;

  int m_priority{0};

  MutationProtectionStatus m_mutationProtection{MutationProtectionStatus::NOT_SET};

  Aws::String m_managedOwnerName;

  FirewallRuleGroupAssociationStatus m_status{FirewallRuleGroupAssociationStatus::NOT_SET};

  Aws::String m_statusMessage;

  Aws::String m_creatorRequestId;

  Aws::String m_creationTime;

  Aws::String m_modificationTime;
  bool m_idHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_firewallRuleGroupIdHasBeenSet = false;
  bool m_vpcIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_priorityHasBeenSet = false;
  bool m_mutationProtectionHasBeenSet = false;
  bool m_managedOwnerNameHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_statusMessageHasBeenSet = false;
  bool m_creatorRequestIdHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_modificationTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53Resolver
}  // namespace Aws
